<?php
include 'db.php'; // Your DB connection
require('fpdf.php'); // Include FPDF for receipts

$office_name = "COLLATE ENTERPRISES";
$office_mobile = "+255 712 345 678";

// ===== Handle form submissions =====

// Assign new fundi
if(isset($_POST['assign'])){
    $project_id = intval($_POST['project_id']);
    $worker_name = $_POST['worker_name'];
    $task = $_POST['task'];
    $agreed_amount = floatval($_POST['agreed_amount']);

    $stmt = $conn->prepare("INSERT INTO assignments (project_id, worker_name, task, agreed_amount) VALUES (?,?,?,?)");
    $stmt->bind_param("issi", $project_id, $worker_name, $task, $agreed_amount);
    $stmt->execute();
    $stmt->close();
    header("Location: assignments.php");
    exit;
}

// Update progress
if(isset($_POST['update_progress'])){
    $id = intval($_POST['id']);
    $progress = intval($_POST['progress']);
    $stmt = $conn->prepare("UPDATE assignments SET progress=? WHERE id=?");
    $stmt->bind_param("ii",$progress,$id);
    $stmt->execute();
    $stmt->close();
    header("Location: assignments.php");
    exit;
}

// Make payment
if(isset($_POST['make_payment'])){
    $id = intval($_POST['id']);
    $amount = floatval($_POST['amount']);
    $reference = !empty($_POST['reference']) ? $_POST['reference'] : "CASH";

    // Get assignment details
    $stmt = $conn->prepare("SELECT * FROM assignments WHERE id=?");
    $stmt->bind_param("i",$id);
    $stmt->execute();
    $res = $stmt->get_result();
    $a = $res->fetch_assoc();
    $stmt->close();

    // Update amount paid
    $stmt = $conn->prepare("UPDATE assignments SET amount_paid = amount_paid + ? WHERE id=?");
    $stmt->bind_param("di",$amount,$id);
    $stmt->execute();
    $stmt->close();

    // Generate PDF receipt
    $pdf = new FPDF();
    $pdf->AddPage();
    $pdf->Image('logo.png',10,10,30); // Adjust logo path
    $pdf->SetFont('Arial','B',16);
    $pdf->Cell(0,10,$office_name,0,1,'C');
    $pdf->SetFont('Arial','',12);
    $pdf->Cell(0,6,"Mobile: $office_mobile",0,1,'C');
    $pdf->Ln(10);

    // Date & time
    $pdf->SetFont('Arial','',10);
    $pdf->Cell(0,6,"Date: ".date('d-m-Y H:i:s'),0,1,'R');
    $pdf->Ln(5);

    // Receipt title
    $pdf->SetFont('Arial','B',14);
    $pdf->Cell(0,8,"Payment Receipt",0,1,'C');
    $pdf->Ln(5);

    // Customer info
    $pdf->SetFont('Arial','',12);
    $pdf->Cell(95,6,"Fundi: ".$a['worker_name'],0,0);
    $pdf->Cell(0,6,"Project: ".$a['project_name'],0,1);
    $pdf->Cell(95,6,"Task: ".$a['task'],0,0);
    $pdf->Cell(0,6,"Reference: ".$reference,0,1);
    $pdf->Ln(5);

    // Amount table
    $pdf->SetFont('Arial','B',12);
    $pdf->Cell(60,8,'Agreed Amount',1,0,'C');
    $pdf->Cell(60,8,'Already Paid',1,0,'C');
    $pdf->Cell(60,8,'New Payment',1,1,'C');

    $pdf->SetFont('Arial','',12);
    $pdf->Cell(60,8,'Tshs. '.number_format($a['agreed_amount'],2),1,0,'C');
    $pdf->Cell(60,8,'Tshs. '.number_format($a['amount_paid'],2),1,0,'C');
    $pdf->Cell(60,8,'Tshs. '.number_format($amount,2),1,1,'C');

    $balance = $a['agreed_amount'] - ($a['amount_paid'] + $amount);
    $pdf->Cell(180,8,'Balance: Tshs. '.number_format($balance,2),1,1,'C');
    $pdf->Ln(10);

    $pdf->Cell(0,8,"Thank you for your payment!",0,1,'C');

    // Output PDF to browser
    $pdf->Output('I','Receipt_'.$a['worker_name'].'_'.date('Ymd_His').'.pdf');

    exit; // Stop further execution so PDF displays
}

// Delete assignment
if(isset($_POST['delete_assignment'])){
    $id = intval($_POST['id']);
    $stmt = $conn->prepare("DELETE FROM assignments WHERE id=?");
    $stmt->bind_param("i",$id);
    $stmt->execute();
    $stmt->close();
    header("Location: assignments.php");
    exit;
}

// Fetch assignments
$assignments = $conn->query("SELECT a.*, p.name AS project_name FROM assignments a LEFT JOIN projects p ON a.project_id=p.id");
?>

<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<title>Assignments</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap5.min.css" rel="stylesheet">
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap5.min.js"></script>
<style>
body { background:#f8f9fa; }
.container { margin-top:40px; }
.table th, .table td { vertical-align: middle; }
.dropdown-toggle::after { display:none; }
</style>
</head>
<body>
<div class="container">
<h2 class="mb-4">Project Assignments</h2>

<!-- Assign Fundi Form -->
<div class="card mb-4">
<div class="card-header">Assign a Fundi</div>
<div class="card-body">
<form method="post" class="row g-2">
<div class="col-md-2"><input type="number" name="project_id" class="form-control" placeholder="Project ID" required></div>
<div class="col-md-2"><input type="text" name="worker_name" class="form-control" placeholder="Fundi Name" required></div>
<div class="col-md-3"><input type="text" name="task" class="form-control" placeholder="Task" required></div>
<div class="col-md-2"><input type="number" step="0.01" name="agreed_amount" class="form-control" placeholder="Agreed Amount" required></div>
<div class="col-md-3"><button type="submit" name="assign" class="btn btn-primary w-100">Assign</button></div>
</form>
</div>
</div>

<!-- Assignments Table -->
<div class="card">
<div class="card-header">Assignments List</div>
<div class="card-body table-responsive">
<table id="assignmentsTable" class="table table-bordered table-hover align-middle">
<thead class="table-dark">
<tr>
<th>#</th>
<th>Project</th>
<th>Fundi</th>
<th>Task</th>
<th>Agreed Amount</th>
<th>Paid</th>
<th>Balance</th>
<th>Progress</th>
<th>Actions</th>
</tr>
</thead>
<tbody>
<?php
if($assignments->num_rows>0){
    $sn=1;
    while($a=$assignments->fetch_assoc()){
        $balance = $a['agreed_amount'] - $a['amount_paid'];
        ?>
<tr>
<td><?= $sn++; ?></td>
<td><?= htmlspecialchars($a['project_name']) ?> (#<?= $a['project_id'] ?>)</td>
<td><?= htmlspecialchars($a['worker_name']) ?></td>
<td><?= htmlspecialchars($a['task']) ?></td>
<td>Tshs. <?= number_format($a['agreed_amount'],2) ?></td>
<td>Tshs. <?= number_format($a['amount_paid'],2) ?></td>
<td>Tshs. <?= number_format($balance,2) ?></td>
<td><?= $a['progress'] ?>%</td>
<td>
<div class="dropdown">
<button type="button" class="btn btn-light btn-sm border-0" data-bs-toggle="dropdown">&#8942;</button>
<ul class="dropdown-menu dropdown-menu-end">
<li><a class="dropdown-item update-progress-btn" href="#" data-bs-toggle="modal" data-bs-target="#progressModal<?= $a['id'] ?>" data-id="<?= $a['id'] ?>" data-progress="<?= $a['progress'] ?>">Update Progress</a></li>
<li><a class="dropdown-item make-payment-btn" href="#" data-bs-toggle="modal" data-bs-target="#paymentModal<?= $a['id'] ?>" data-id="<?= $a['id'] ?>" data-worker="<?= htmlspecialchars($a['worker_name']) ?>" data-project="<?= htmlspecialchars($a['project_name']) ?>" data-agreed="<?= number_format($a['agreed_amount'],2) ?>" data-paid="<?= number_format($a['amount_paid'],2) ?>">Make Payment</a></li>
<li><a class="dropdown-item" data-bs-toggle="modal" data-bs-target="#viewModal<?= $a['id'] ?>">View</a></li>
<li><a class="dropdown-item text-danger" data-bs-toggle="modal" data-bs-target="#deleteModal<?= $a['id'] ?>">Delete</a></li>
<!-- New options -->
<!-- Print single assignment receipt -->
    <li>
      <a class="dropdown-item text-primary"
         href="print_receipt.php?id=<?= $a['id'] ?>"
         target="_blank" rel="noopener noreferrer">
        🧾 Print Receipt
      </a>
    </li>

    <!-- Print all payments for this assignment -->
    <li>
      <a class="dropdown-item text-info"
         href="payment_report.php?assignment_id=<?= $a['id'] ?>"
         target="_blank" rel="noopener noreferrer">
        📊 Payment Report
      </a>
    </li>

</ul>
</div>
</td>
</tr>

<!-- Update Progress Modal -->
<div class="modal fade" id="progressModal<?= $a['id'] ?>" tabindex="-1" data-bs-backdrop="static" data-bs-keyboard="false">
<div class="modal-dialog">
<div class="modal-content">
<div class="modal-header">
<h5 class="modal-title">Update Progress</h5>
<button type="button" class="btn-close" data-bs-dismiss="modal"></button>
</div>
<div class="modal-body">
<form method="post" action="" id="progressForm<?= $a['id'] ?>">
<input type="hidden" name="id" value="<?= $a['id'] ?>">
<div class="mb-3">
<label for="progressInput<?= $a['id'] ?>" class="form-label">Progress %</label>
<input type="number" name="progress" class="form-control progress-input" id="progressInput<?= $a['id'] ?>" placeholder="Enter progress %" required>
</div>
</form>
</div>
<div class="modal-footer">
<button type="submit" name="update_progress" class="btn btn-primary" form="progressForm<?= $a['id'] ?>">Update</button>
<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
</div>
</div>
</div>
</div>

<!-- Payment Modal -->
<div class="modal fade" id="paymentModal<?= $a['id'] ?>" tabindex="-1" aria-labelledby="paymentModalLabel<?= $a['id'] ?>" aria-hidden="true" data-bs-backdrop="static" data-bs-keyboard="false">
<div class="modal-dialog">
<div class="modal-content">
<div class="modal-header">
<h5 class="modal-title text-success" id="paymentModalLabel<?= $a['id'] ?>">Make Payment</h5>
<button type="button" class="btn-close" data-bs-dismiss="modal"></button>
</div>
<div class="modal-body">
<form method="post" action="" id="paymentForm<?= $a['id'] ?>">
<input type="hidden" name="id" value="<?= $a['id'] ?>">

<div class="mb-3">
<label for="workerName<?= $a['id'] ?>" class="form-label">Fundi</label>
<input type="text" id="workerName<?= $a['id'] ?>" class="form-control" value="<?= htmlspecialchars($a['worker_name']) ?>" readonly>
</div>

<div class="mb-3">
<label for="projectName<?= $a['id'] ?>" class="form-label">Project</label>
<input type="text" id="projectName<?= $a['id'] ?>" class="form-control" value="<?= htmlspecialchars($a['project_name']) ?>" readonly>
</div>

<div class="mb-3">
<label for="agreedAmount<?= $a['id'] ?>" class="form-label">Agreed Amount (Tshs.)</label>
<input type="text" id="agreedAmount<?= $a['id'] ?>" class="form-control" value="<?= number_format($a['agreed_amount'], 2) ?>" readonly>
</div>

<div class="mb-3">
<label for="amountPaid<?= $a['id'] ?>" class="form-label">Already Paid (Tshs.)</label>
<input type="text" id="amountPaid<?= $a['id'] ?>" class="form-control" value="<?= number_format($a['amount_paid'], 2) ?>" readonly>
</div>

<div class="mb-3">
<label for="amount<?= $a['id'] ?>" class="form-label">New Payment Amount (Tshs.)</label>
<input type="number" name="amount" id="amount<?= $a['id'] ?>" class="form-control" placeholder="Enter payment amount" required>
</div>

<div class="mb-3">
<label for="reference<?= $a['id'] ?>" class="form-label">Reference (optional)</label>
<input type="text" name="reference" id="reference<?= $a['id'] ?>" class="form-control" placeholder="e.g. CASH, M-PESA">
</div>

</form>
</div>
<div class="modal-footer">
<button type="submit" form="paymentForm<?= $a['id'] ?>" name="make_payment" class="btn btn-success">Submit Payment</button>
<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
</div>
</div>
</div>
</div>

<!-- View Modal -->
<div class="modal fade" id="viewModal<?= $a['id'] ?>" tabindex="-1" data-bs-backdrop="static" data-bs-keyboard="false">
<div class="modal-dialog">
<div class="modal-content">
<div class="modal-header">
<h5 class="modal-title">Assignment Details</h5>
<button type="button" class="btn-close" data-bs-dismiss="modal"></button>
</div>
<div class="modal-body">
<p><strong>Project:</strong> <?= htmlspecialchars($a['project_name']) ?> (#<?= $a['project_id'] ?>)</p>
<p><strong>Fundi:</strong> <?= htmlspecialchars($a['worker_name']) ?></p>
<p><strong>Task:</strong> <?= htmlspecialchars($a['task']) ?></p>
<p><strong>Agreed Amount:</strong> Tshs. <?= number_format($a['agreed_amount'],2) ?></p>
<p><strong>Paid:</strong> Tshs. <?= number_format($a['amount_paid'],2) ?></p>
<p><strong>Balance:</strong> Tshs. <?= number_format($balance,2) ?></p>
<p><strong>Progress:</strong> <?= $a['progress'] ?>%</p>
</div>
<div class="modal-footer">
<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
</div>
</div>
</div>
</div>

<!-- Delete Assignment Modal -->
<div class="modal fade" id="deleteModal<?= $a['id'] ?>" tabindex="-1" aria-labelledby="deleteModalLabel<?= $a['id'] ?>" aria-hidden="true" data-bs-backdrop="static" data-bs-keyboard="false">
<div class="modal-dialog">
<div class="modal-content">
<div class="modal-header">
<h5 class="modal-title text-danger" id="deleteModalLabel<?= $a['id'] ?>">Delete Assignment</h5>
<button type="button" class="btn-close" data-bs-dismiss="modal"></button>
</div>
<div class="modal-body">
<form method="post" action="" id="deleteForm<?= $a['id'] ?>">
<input type="hidden" name="id" value="<?= $a['id'] ?>">
<p>Are you sure you want to delete this assignment?</p>
</form>
</div>
<div class="modal-footer">
<button type="submit" form="deleteForm<?= $a['id'] ?>" name="delete_assignment" class="btn btn-danger">Delete</button>
<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
</div>
</div>
</div>
</div>

<?php
    }
}else{
    echo "<tr><td colspan='9' class='text-center'>No assignments found</td></tr>";
}
?>
</tbody>
</table>
</div>
</div>

<div class="text-center mt-4">
<a href="index.php" class="btn btn-primary">Home</a>
</div>
</div>

<script>
$(document).ready(function(){
    $('#assignmentsTable').DataTable({
        "pageLength": 10,
        "lengthChange": false,
        "language": {
            "search": "Filter:"
        }
    });

    // Prefill progress modal
    $('.update-progress-btn').click(function(){
        var id = $(this).data('id');
        var progress = $(this).data('progress');
        $('#progressInput'+id).val(progress);
    });

    // Prefill payment modal
    $('.make-payment-btn').click(function(){
        var id = $(this).data('id');
        $('#workerName'+id).val($(this).data('worker'));
        $('#projectName'+id).val($(this).data('project'));
        $('#agreedAmount'+id).val($(this).data('agreed'));
        $('#amountPaid'+id).val($(this).data('paid'));
    });
});
</script>

</body>
</html>
